/*******************************************************
Filename		:  storetw.sql
Release 		:  c2.0
SIR			:  
Description		:  Storetw user creation and grants.
Author			:  Ganesh Thadkamalla
Date			:  10/01/2002.
Comments		:  6/9/03 -- Added explicit grants to storetw on storet and storet1 tables.
			   6/20/03 -- revoke create session
			   8/11/03 -- added materialized view grants -JW
**********************************************************/
spool storetw.log
connect system/xxxx@storet.sdc
CREATE USER "STORETW"  PROFILE "DEFAULT" IDENTIFIED BY "storetw" 
    DEFAULT 
    TABLESPACE "STORETDATA" TEMPORARY 
    TABLESPACE "TEMP" QUOTA UNLIMITED 
    ON STORETdata QUOTA UNLIMITED 
    ON STORETINDX ACCOUNT UNLOCK;

grant ALTER SESSION to storetw;
grant CREATE CLUSTER to storetw;
grant CREATE INDEXTYPE to storetw;
grant CREATE OPERATOR to storetw;
grant CREATE PROCEDURE to storetw;
grant CREATE SEQUENCE to storetw;
grant CREATE SESSION to storetw;
grant CREATE SYNONYM to storetw;
grant CREATE TABLE to storetw;
grant CREATE TRIGGER to storetw;
grant CREATE TYPE to storetw;
grant CREATE VIEW to storetw;
grant create materialized view to storetw;
grant query rewrite to storetw;
grant create session to storet, storet1;

connect storet/xxxxxx@storet.sdc
--grant select on storet.tsmhuc to storetw;
grant select on APP_HELP to storetw;
grant select on FORMS_HELP to storetw;
grant select on HELP_KEYWORDS to storetw;
grant select on HELP_RELATED to storetw;
grant select on TSMERMSG to storetw;
grant select on TSMESTRY to storetw;
grant select on TSMFHU to storetw;
grant select on TSMGEOPA to storetw;
grant select on TSMGEOUN to storetw;
grant select on TSMLTHUN to storetw;
grant select on TSMMAD to storetw;
grant select on TSMNAICS to storetw;
grant select on TSMNAL to storetw;
grant select on TSMPRMVL to storetw;
grant select on TSMPROLE to storetw;
grant select on TSMPSR to storetw;
grant select on TSMRRR to storetw;
grant select on TSMSIC to storetw;
grant select on TSMVSTC to storetw;
grant select on TSRANLEQ to storetw;
grant select on TSRBIOPT to storetw;
grant select on TSRCALT to storetw;
grant select on TSRCHALS to storetw;
grant select on TSRCHAR to storetw;
grant select on TSRCHTYP to storetw;
grant select on TSRCPV to storetw;
grant select on TSRCTCA to storetw;
grant select on TSRFLDGR to storetw;
grant select on TSRLBRMK to storetw;
grant select on TSRMATRX to storetw;
grant select on TSRPROJSQ to storetw;
grant select on TSRRLIST to storetw;
grant select on TSRRPARM to storetw;
grant select on TSRUOM to storetw;


connect storet1/xxxxxx@storet.sdc
grant select on TSMADDR to storetw;
grant select on TSMALP to storetw;
grant select on TSMBLOB to storetw;
grant select on TSMCHKPT to storetw;
grant select on TSMCPORG to storetw;
grant select on TSMCSNG to storetw;
grant select on TSMEADDR to storetw;
grant select on TSMEISN to storetw;
grant select on TSMERS to storetw;
grant select on TSMESTLC to storetw;
grant select on TSMFCLTY to storetw;
grant select on TSMFILL to storetw;
grant select on TSMFNA to storetw;
grant select on TSMFSA to storetw;
grant select on TSMGLL to storetw;
grant select on TSMGNTXT to storetw;
grant select on TSMHOLE to storetw;
grant select on TSMIGUA to storetw;
grant select on TSMINTVL to storetw;
grant select on TSMLOG to storetw;
grant select on TSMOCNLC to storetw;
grant select on TSMOPNG to storetw;
grant select on TSMORGAN to storetw;
grant select on TSMPCOA to storetw;
grant select on TSMPERSN to storetw;
grant select on TSMPIPE to storetw;
grant select on TSMPMGRD to storetw;
grant select on TSMPMTCT to storetw;
grant select on TSMPPA to storetw;
grant select on TSMPPRA to storetw;
grant select on TSMPRA to storetw;
grant select on TSMPROGM to storetw;
grant select on TSMPROJ to storetw;
grant select on TSMPRPRA to storetw;
grant select on TSMPSA to storetw;
grant select on TSMPSRA to storetw;
grant select on TSMPSW to storetw;
grant select on TSMPUMP to storetw;
grant select on TSMRFLBL to storetw;
grant select on TSMSCTS to storetw;
grant select on TSMSOI to storetw;
grant select on TSMSPRNG to storetw;
grant select on TSMSTATN to storetw;
grant select on TSMTBINF to storetw;
grant select on TSMUOA to storetw;
grant select on TSMUSER to storetw;
grant select on TSMVSC to storetw;
grant select on TSMWELL to storetw;
grant select on TSMWLE to storetw;
grant select on TSRAAL to storetw;
grant select on TSRADL to storetw;
grant select on TSRANLPR to storetw;
grant select on TSRBRG to storetw;
grant select on TSRBRGI to storetw;
grant select on TSRCCGA to storetw;
grant select on TSRCHDEF to storetw;
grant select on TSRCHGRP to storetw;
grant select on TSRCITN to storetw;
grant select on TSRCLDES to storetw;
grant select on TSRCPA to storetw;
grant select on TSRDLIN to storetw;
grant select on TSRDQL to storetw;
grant select on TSREOD to storetw;
grant select on TSRFACOA to storetw;
grant select on TSRFAFSA to storetw;
grant select on TSRFAPEA to storetw;
grant select on TSRFAPRA to storetw;
grant select on TSRFAQSA to storetw;
grant select on TSRFDACT to storetw;
grant select on TSRFDSET to storetw;
grant select on TSRFLDPR to storetw;
grant select on TSRFQS to storetw;
grant select on TSRFQSDP to storetw;
grant select on TSRFQSPA to storetw;
grant select on TSRGRCFG to storetw;
grant select on TSRHCSC to storetw;
grant select on TSRLAB to storetw;
grant select on TSRLSPP to storetw;
grant select on TSROAPA to storetw;
grant select on TSROAPCA to storetw;
grant select on TSROLSPA to storetw;
grant select on TSROPPRD to storetw;
grant select on TSRPOPA to storetw;
grant select on TSRRCI to storetw;
grant select on TSRRLRA to storetw;
grant select on TSRRQCAF to storetw;
grant select on TSRRSULT to storetw;
grant select on TSRSDP to storetw;
grant select on TSRSMPLE to storetw;
grant select on TSRSTVST to storetw;
grant select on TSRTNOD to storetw;
grant select on TSRTOD to storetw;
grant select on TSRTPA to storetw;
grant select on TSRTRIP to storetw;
grant select on TSRTSA to storetw;


connect system/xxxxx@storet.sdc
revoke create session from storet, storet1;
-- Coalesce storetdata and storetindx tablespaces;
alter tablespace storetdata coalesce;
alter tablespace storetindx coalesce;
spool off;